Option Strict Off
Imports System.Collections
Public Class Helper
    Dim pc As PluginClass

    Public Function addPluginOption(optionType As String, optionLabel As String, optionStoreName As String) As ArrayList
        'optionType:
        '   Text:           Input text
        '   Combo3:         Combo with options (Enabled=0, Disabled=1)
        '   Sensors:        Combo with available sensors
        '   ColorRGB:       Combo with common RGB colors = 16bitinteger
        '   ComboOnOff:     Combo with options (Disabled=0, Enabled=1)
        '   ComboYesNo:     Combo with options (Yes=Yes, No=No)
        '   FontStyle:      Combo with options of the fonts the user has installed
        '   Orientation:    Combo with options (Horizontal=0, Vertical=1)
        '   Alignment:      Left=-1,Center=0,Right=1
        '   Numeric|1|480   Numeric, from 1 to 480, those numbers can be modified


        'No spaces, no underscore
        optionStoreName = optionStoreName.Replace(" ", "")
        optionStoreName = optionStoreName.Replace("_", "")
        Return New ArrayList({optionType, optionLabel, optionStoreName})
    End Function

    Public Function lcd2_addLine(xpos As Integer, ypos As Integer, color As Integer) As ArrayList
        Return New ArrayList({xpos, ypos, color})
    End Function
End Class

Public Class PluginClass
    Implements GOverlayPlugin.Interfaces.IPlugin
    Public testvar As Integer = 1
    Public pluginId As String = "uniquePluginID#123553."
    Public pluginName As String = "GOverlay Example Plugin: Complex Draw"
    Public Helper As Helper = New Helper

    Private objHost As GOverlayPlugin.Interfaces.IHost

    Public Sub Initialize(ByVal Host As GOverlayPlugin.Interfaces.IHost) Implements GOverlayPlugin.Interfaces.IPlugin.Initialize
        objHost = Host
    End Sub



    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------NAME OF THE PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Name() As String Implements GOverlayPlugin.Interfaces.IPlugin.Name        
        'Return your plugin name
        Get
            Return pluginName
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DISPLAY THE PLUGIN APPLIES TO
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Display() As String Implements GOverlayPlugin.Interfaces.IPlugin.Display
        'Return the display this plugin belongs to
        Get
            Return "lcdsys"
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DESCRIPTION OF THE PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Description() As String Implements GOverlayPlugin.Interfaces.IPlugin.Description
        'Return the display this plugin belongs to
        Get
            Return "This plugin performs a complex draw (drawing ourselves) as well as keeping the simple draw of the previous example (goverlay drawing those)."
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------COMBO BOXES FOR USE IN YOUR PLUGIN (EITHER ELEMENTS OPTIONS OR PLUGIN OPTIONS)
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function ComboBoxes() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.ComboBoxes
        'Create custom ComboBox for your configuration to use
        Dim boxes As New Hashtable
        Dim myboxOptions As New Hashtable
        myboxOptions.Add("celsius", "Celsius Unit")
        myboxOptions.Add("fahrenheit", "Fahrenheit Unit")

        boxes.Add(pluginId & "unit", myboxOptions)

        Dim myboxDirections As New Hashtable
        myboxDirections.Add("left", "To the Left")
        myboxDirections.Add("right", "To the Right")
        myboxDirections.Add("top", "To the Top")
        myboxDirections.Add("bottom", "To the Bottom")

        boxes.Add(pluginId & "lineDirection", myboxDirections)
        Return boxes
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------PLUGIN OPTIONS LIST FOR THE USER TO CONFIGURE
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function PluginOptions(pluginCurrentOptions As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptions
        Dim options As New Hashtable
        'Option: option_index as integer, option_data as ArrayList
        'Option_Data: option_type as string, option_label as string, option_name as string (no spaces, no _)
        options.Add(0, Helper.addPluginOption("Text", "A note", "note"))
        options.Add(1, Helper.addPluginOption(pluginId & "unit", "Type of unit to use", "unit"))
        options.Add(2, Helper.addPluginOption("ColorRGB", "Line Color", "lineColor"))
        Return options
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------PLUGIN DEFAULT OPTIONS WHEN INSTALLED
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function PluginOptionsDefault() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptionsDefault
        'Set the default values you want to have on plugin, if the user doesnt change any option, he will have this settings
        Dim options As New Hashtable
        options("unit") = "celsius"
        options("note") = "for demo purposes"
        options("lineColor") = "65535"  'white
        Return options
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------LIST OF AVAILABLE ELEMENTS OF YOUR PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.AvailableSensors
        'Create the list of the sensors/elements this plugin has
        'You can access your pluginOptions here as pluginOptions(your_option)    

        objHost.DebugMessage("DemoPlugin - Listing the plugin elements available")

        Dim selectedUnit As String = pluginOptions("unit")

        'Options: SensorTag, Sensor Display-Name
        Dim sensors As New System.Collections.Generic.Dictionary(Of String, String)

        sensors.Add(pluginId & "temp", "Temperature (in " & selectedUnit & ")")
        sensors.Add(pluginId & "usage", "Usage")
        sensors.Add(pluginId & "line", "Line")
        sensors.Add(pluginId & "square", "Square")
        sensors.Add(pluginId & "text", "A random text")

        Return sensors
    End Function

    Function LCDSys2_AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_AvailableSensors
        Return AvailableSensors(pluginOptions)
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------SPECIFY FOR EACH SENSOR IF IT HAS A CUSTOM DRAW
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function SensorHasCustomDraw(sensor_name As String) As Boolean Implements GOverlayPlugin.Interfaces.IPlugin.SensorHasCustomDraw
        'All sensors are drawn with GOverlay default drawing
        If (sensor_name = pluginId & "temp" Or sensor_name = pluginId & "usage") Then
            Return False
        End If
        'All other elements we do the drawing
        Return True
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------EACH PLUGIN ELEMENT OPTION FOR THE USER TO CONFIGURE
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function CreateOptions(sensor_name As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CreateOptions
        'No options because GOverlay draws instead of us
        Dim options As New Hashtable

        If (sensor_name = pluginId & "temp" Or sensor_name = pluginId & "usage") Then
        ElseIf sensor_name = pluginId & "line" Then
            options.Add(0, Helper.addPluginOption(pluginId & "lineDirection", "Line Direction", "lineDirection"))
            options.Add(1, Helper.addPluginOption("Numeric|1|300", "Line Width", "lineWidth"))
        ElseIf sensor_name = pluginId & "square" Then
            options.Add(0, Helper.addPluginOption("ColorRGB", "The Color", "squareColor"))
            options.Add(1, Helper.addPluginOption("Numeric|1|480", "Width", "width"))
            options.Add(2, Helper.addPluginOption("Numeric|1|320", "height", "height"))
        ElseIf sensor_name = pluginId & "text" Then
            options.Add(0, Helper.addPluginOption("Text", "A text", "text"))
            options.Add(1, Helper.addPluginOption("Numeric|1|480", "Width", "width"))
            options.Add(2, Helper.addPluginOption("Numeric|1|320", "height", "height"))
        End If

        Return options

    End Function

    Public Function LCDSys2_CreateOptions(sensor_name As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_CreateOptions
        'Same as lcd1
        Return CreateOptions(sensor_name, elementData)
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DEFAULT PLUGIN ELEMENT OPTION WHEN THE USER ADDS IT FOR THE FIRST TIME
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function SetDefaultOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.SetDefaultOptions
        'Set the default values you want to have on your sensor when its created, if the user doesnt change any option, he will have this settings

        objHost.DebugMessage("DemoPlugin - Added plugin element: " & sensorId & " to the display screen")

        If sensorId = pluginId & "temp" Then
            'For temp, lets modify the goverlay defaults
            elementData("width") = 100
            elementData("height") = 41
            elementData("maxnum") = 5
        ElseIf sensorId = pluginId & "line" Then
            elementData("lineDirection") = "right"
            elementData("lineWidth") = 1
            elementData("width") = 50  'IMPORTANT, OR IT WONT SHOW
            elementData("height") = 50  'IMPORTANT, OR IT WONT SHOW
        ElseIf sensorId = pluginId & "square" Then
            elementData("squareColor") = 65535
            elementData("width") = 50  'IMPORTANT, OR IT WONT SHOW
            elementData("height") = 50  'IMPORTANT, OR IT WONT SHOW
        ElseIf sensorId = pluginId & "text" Then
            elementData("text") = "a text"
            elementData("width") = 50  'IMPORTANT, OR IT WONT SHOW
            elementData("height") = 50  'IMPORTANT, OR IT WONT SHOW
        End If

        Return elementData
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------CALLBACK FROM GOVERLAY TO YOUR PLUGIN FOR SOME EVENTS
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function CallBack(method As String) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CallBacks
        Dim returnHT As Hashtable = New Hashtable

        Try

            Dim value As Integer = 0

            If method = "willrequestvalues" Then
                'Comes here once per run (only if sensors are used thru here)                
            Else
                'This will be used for non-custom draw elements
                value = InternalGatherSensorsValues(method)
            End If

            returnHT("value") = value

        Catch ex As Exception
            objHost.DebugMessage("Error grabbing action : " & method)
        End Try

        Return returnHT
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------CUSTOM DRAW ON THE DISPLAY FOR EACH ELEMENT
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function DisplayOnLCD(sensorId As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.DisplayOnLCD
        'No custom draw examples on LCD1
        Return New ArrayList()
    End Function

    Public Function LCDSys2_DisplayOnLCD(sensor_name As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_DisplayOnLCD

        Dim MYpluginOptions As Hashtable = pluginOptions(pluginName)

        If sensor_name = pluginId & "line" Then
            Dim aLine As New ArrayList
            aLine.Add(Helper.lcd2_addLine(elementData("x"), elementData("y"), MYpluginOptions("lineColor")))

            Dim endX As Integer = elementData("x")
            Dim endY As Integer = elementData("y")
            If elementData("lineDirection") = "left" Then
                endX = CInt(elementData("x")) - CInt(elementData("width"))
            ElseIf elementData("lineDirection") = "right" Then
                endX = CInt(elementData("x")) + CInt(elementData("width"))
            ElseIf elementData("lineDirection") = "top" Then
                endY = CInt(elementData("y")) - CInt(elementData("height"))
            ElseIf elementData("lineDirection") = "bottom" Then
                endY = CInt(elementData("y")) + CInt(elementData("height"))
            End If

            If endX < 0 Then
                endX = 0
            End If
            If endX > 480 Then
                endX = 480
            End If
            If endY > 320 Then
                endY = 320
            End If
            If endY < 0 Then
                endY = 0
            End If

            aLine.Add(Helper.lcd2_addLine(endX, endY, MYpluginOptions("lineColor")))

            objHost.DebugMessage("DemoPlugin - Drawing line from " & elementData("x") & ";" & elementData("y") & " to " & endX & ";" & endY & " -- elementW: " & elementData("width") & " --elementH: " & elementData("height") & " and color: " & MYpluginOptions("lineColor") & " and direction: " & elementData("lineDirection"))

            objHost.LCDSys2_Draw_Lines(aLine, True, -1)
        ElseIf sensor_name = pluginId & "square" Then
            objHost.LCDSys2_Draw_Rectangle(elementData("x"), elementData("y"), CInt(elementData("x")) + CInt(elementData("width")), CInt(elementData("y")) + CInt(elementData("height")), elementData("squareColor"), 1, 0)
        ElseIf sensor_name = pluginId & "text" Then
            objHost.LCDSys2_Draw_Text_Font(elementData("x"), elementData("y"), elementData("text"), elementData("width"), 65535, 0, "Arial_20px.bin")
        End If

        Return New ArrayList()
    End Function


    Public Function InternalGatherSensorsValues(sensorName As String) As String
        Dim theUnit As String = objHost.AccessHost("plugin_options", pluginName, "unit", "")

        If sensorName = pluginId & "temp" Then
            If theUnit = "celsius" Then
                Return 50
            Else
                Return 102
            End If
        ElseIf sensorName = pluginId & "usage" Then
            Return 55
        End If

        Return 0
    End Function
End Class