Option Strict Off
Imports System.Collections
Imports Microsoft.Win32
Imports System.Text.RegularExpressions
Imports System.IO
Imports System.IO.MemoryMappedFiles
Imports System.Runtime.InteropServices
Imports System.Threading
Imports System.Security
Imports System.ComponentModel
Imports Microsoft.Win32.SafeHandles
Imports System.Runtime.ConstrainedExecution
Imports System.Security.Permissions

Imports System.Collections.Generic
Imports System.Linq
Imports System.Text

Namespace E69IL2CoD
    Public Class IL2CoDData
        Public Enum ParameterTypes
            Nil
            M_Random
            M_Shake
            M_CabinDamage
            M_CabinState
            M_NamedDamage
            M_SystemWear
            M_Health
            C_Steering
            C_Brake
            C_Throttle
            C_Trigger
            C_Pitch
            C_Mix
            C_WaterRadiator
            C_OilRadiator
            C_RadiatorAutomation
            C_PitchAutomation
            C_Compressor
            C_Afterburner
            C_BoostEnabler
            C_SlowRunningCutOut
            C_Magneto
            C_Feather
            C_CarbHeater
            C_HatchDoor
            C_HatchJettison
            C_Timer
            C_Timer1
            C_Aileron
            C_Elevator
            C_Rudder
            C_AileronTrim
            C_ElevatorTrim
            C_RudderTrim
            C_TailwheelLock
            C_LandingFlap
            C_LeadingEdgeSlats
            C_Undercarriage
            C_UndercarriageEmergency
            C_BombBayDoor
            C_Airbrake
            C_FuelTankSelector
            C_TelepirometroElettrico
            C_AltimeterPinion
            C_AnemometroPinion
            C_BombSight
            C_Sight
            C_Bombenabwurfgerat
            C_KraftstoffSelector
            C_LiquidGauge0
            C_LiquidGauge1
            C_PriLights
            C_SecLights
            C_SightLights
            C_PitotHeater
            C_Handpumpe
            C_RadTXRX
            C_RadPriNav
            C_RadSecNav
            C_Kurssteuerung
            A_Steering
            A_Brake
            A_Aileron
            A_Elevator
            A_Rudder
            A_AileronTrim
            A_ElevatorTrim
            A_RudderTrim
            A_Undercarriage
            A_UndercarriageShock
            A_UndercarriageWheel
            A_HatchDoor
            A_BombBayDoor
            A_ImpellerAngle
            A_ImpellerAngularVelocity
            A_ImpellerUnfold
            A_LandingFlap
            A_Airbrake
            A_EngineAirRadiator
            A_EngineWaterRadiator
            A_EngineOilRadiator
            A_LeadingEdgeSlat
            Z_Coordinates
            Z_Orientation
            Z_Overload
            Z_AltitudeAGL
            Z_AltitudeMSL
            Z_VelocityIAS
            Z_VelocityTAS
            Z_VelocityMach
            Z_AmbientAirTemperature
            S_ElectricVoltage
            S_ElectricIncandescingRatio
            S_ElectricAmperage
            S_ElectricPrimaryPitLight
            S_ElectricSecondaryPitLight
            S_ElectricSightLight
            S_FuelReserve
            S_HatchDoor
            S_UndercarriageValve
            S_PneumoContainerPressure
            S_PneumoLinePressure
            S_HydroPressure
            S_HydroReserve
            S_Sturzanlage
            S_GunOperation
            S_GunReserve
            S_GunClipReserve
            S_BombReserve
            S_Fenster
            S_PitotHeater
            S_Bombenabwurfgerat
            S_Turret
            M_Reserved000
            M_Reserved001
            M_Reserved002
            M_Reserved003
            M_Reserved004
            M_Reserved005
            M_Reserved006
            M_Reserved007
            M_Reserved008
            M_Reserved009
            M_Reserved00A
            M_Reserved00B
            M_Reserved00C
            M_Reserved00D
            M_Reserved00E
            M_Reserved00F
            M_Reserved010
            M_Reserved011
            M_Reserved012
            M_Reserved013
            M_Reserved014
            M_Reserved015
            M_Reserved016
            M_Reserved017
            M_Reserved018
            M_Reserved019
            M_Reserved01A
            M_Reserved01B
            M_Reserved01C
            M_Reserved01D
            M_Reserved01E
            M_Reserved01F
            I_Timer
            I_AmbientTemp
            I_EngineRPM
            I_EngineManPress
            I_EngineBoostPress
            I_EngineWatPress
            I_EngineOilPress
            I_EngineFuelPress
            I_EngineWatTemp
            I_EngineRadTemp
            I_EngineOilTemp
            I_EngineOilRadiatorTemp
            I_EngineTemperature
            I_EngineCarbTemp
            I_Pitch
            I_VelocityIAS
            I_Altitude
            I_Variometer
            I_Slip
            I_MagneticCompass
            I_RepeaterCompass
            I_Peilzeiger
            I_FuelReserve
            I_LiquidReserve
            I_Voltamperemeter
            I_Voltmeter
            I_Amperemeter
            I_HydroPressure
            I_HydroEmPressure
            I_Turn
            I_AH
            I_DirectionIndicator
            I_SlavedCompass
            I_Suction
            I_AFN
            I_ADF
            I_RDF
            I_RMI
            I_FLRC
            I_Kurssteuerung
            I_BombSight
        End Enum
    End Class
End Namespace

Public Class Class1
    Implements GOverlayPlugin.Interfaces.IPlugin
    Public testvar As Integer = 1

    Private objHost As GOverlayPlugin.Interfaces.IHost
    Public PluginName As String = "IL2 Cliffs of Dover (ATAG)"

    Public Cache As String

    Public LastCache As New System.Collections.Hashtable


    Private IL2CoDFile As MemoryMappedFile
    Private FileMapView As MemoryMappedViewAccessor


    Public td As New System.Collections.Hashtable



    Public Sub Initialize(ByVal Host As GOverlayPlugin.Interfaces.IHost) Implements GOverlayPlugin.Interfaces.IPlugin.Initialize
        objHost = Host
    End Sub

    Public ReadOnly Property Description() As String Implements GOverlayPlugin.Interfaces.IPlugin.Description
        'Return your plugin name
        Get
            Return "This plugin allows to read the IL2 Cliffs of Dover telemetry data with the help of the ATAG MOD." & vbNewLine & vbNewLine & _
                "Make sure you have the latest version of the ATAG mod with COD or this will not work" & vbNewLine & vbNewLine & _
                "Remember to UPLOAD the LCDSysInfo files with GOverlay" & vbNewLine & vbNewLine & _
                "Developed by TheLaGmAn"
        End Get
    End Property

    Public ReadOnly Property Name() As String Implements GOverlayPlugin.Interfaces.IPlugin.Name
        'Return your plugin name
        Get
            Return PluginName
        End Get
    End Property

    Public ReadOnly Property Display() As String Implements GOverlayPlugin.Interfaces.IPlugin.Display
        'Return the display this plugin belongs to
        Get
            Return "lcdsys"
        End Get
    End Property

    Function CallBack(method As String) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CallBacks
        'Send the request to upload all the files
        objHost.DebugMessage("IL2 Plugin - Callback Requested: " & method)
        'objHost.DebugMessage("IL2 Plugin - " & method)

        Try
            Dim returnHT As Hashtable = New Hashtable

            Dim value = 0

            If method = "willrequestvalues" Then
                'Comes here once per run (only if sensors are used thru here)
                GrabData()
            ElseIf method = "willrequestdisplay" Then
                'objHost.DebugMessage("wrd")
                GrabData()
            ElseIf method = "reqimagesbutton" Then
                objHost.AccessHost("plugin_upload_files", PluginName, "reqimages", "")
            Else
                Dim name = method.Replace("IL2COD.", "")
                'objHost.DebugMessage(name)
                value = td(name)
            End If

            returnHT("value") = value

            Return returnHT
        Catch ex As Exception
            objHost.DebugMessage("Error grabbing action : " & method)
        End Try

    End Function

    Function AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.AvailableSensors
        'Create the list of the sensors/elements this plugin has
        'You can access your pluginOptions here as pluginOptions(your_option)        
        Try


            Dim sensors As New System.Collections.Generic.Dictionary(Of String, String)

            Try
                GrabData()
            Catch ex As Exception
                'Fallback in case the sensors cant be read (il2 offline)
                sensors.Add("IL2COD.M_Random", "M_Random : Unknown")
                sensors.Add("IL2COD.M_Shake", "M_Shake : Unknown")
                sensors.Add("IL2COD.M_CabinDamage", "M_CabinDamage : Unknown")
                sensors.Add("IL2COD.M_CabinState", "M_CabinState : Unknown")
                sensors.Add("IL2COD.M_NamedDamage", "M_NamedDamage : Unknown")
                sensors.Add("IL2COD.M_SystemWear", "M_SystemWear : Unknown")
                sensors.Add("IL2COD.M_Health", "M_Health : Unknown")
                sensors.Add("IL2COD.C_Steering", "C_Steering : Unknown")
                sensors.Add("IL2COD.C_Brake", "C_Brake : Unknown")
                sensors.Add("IL2COD.C_Throttle", "C_Throttle : Unknown")
                sensors.Add("IL2COD.C_Trigger", "C_Trigger : Unknown")
                sensors.Add("IL2COD.C_Trigger2", "C_Trigger2 : Unknown")
                sensors.Add("IL2COD.C_Pitch", "C_Pitch : Unknown")
                sensors.Add("IL2COD.C_Mix", "C_Mix : Unknown")
                sensors.Add("IL2COD.C_WaterRadiator", "C_WaterRadiator : Unknown")
                sensors.Add("IL2COD.C_OilRadiator", "C_OilRadiator : Unknown")
                sensors.Add("IL2COD.C_RadiatorAutomation", "C_RadiatorAutomation : Unknown")
                sensors.Add("IL2COD.C_PitchAutomation", "C_PitchAutomation : Unknown")
                sensors.Add("IL2COD.C_Compressor", "C_Compressor : Unknown")
                sensors.Add("IL2COD.C_Afterburner", "C_Afterburner : Unknown")
                sensors.Add("IL2COD.C_BoostEnabler", "C_BoostEnabler : Unknown")
                sensors.Add("IL2COD.C_SlowRunningCutOut", "C_SlowRunningCutOut : Unknown")
                sensors.Add("IL2COD.C_Magneto", "C_Magneto : Unknown")
                sensors.Add("IL2COD.C_Feather", "C_Feather : Unknown")
                sensors.Add("IL2COD.C_CarbHeater", "C_CarbHeater : Unknown")
                sensors.Add("IL2COD.C_HatchDoor", "C_HatchDoor : Unknown")
                sensors.Add("IL2COD.C_HatchJettison", "C_HatchJettison : Unknown")
                sensors.Add("IL2COD.C_Timer", "C_Timer : Unknown")
                sensors.Add("IL2COD.C_Timer1", "C_Timer1 : Unknown")
                sensors.Add("IL2COD.C_Aileron", "C_Aileron : Unknown")
                sensors.Add("IL2COD.C_Elevator", "C_Elevator : Unknown")
                sensors.Add("IL2COD.C_Rudder", "C_Rudder : Unknown")
                sensors.Add("IL2COD.C_AileronTrim", "C_AileronTrim : Unknown")
                sensors.Add("IL2COD.C_ElevatorTrim", "C_ElevatorTrim : Unknown")
                sensors.Add("IL2COD.C_RudderTrim", "C_RudderTrim : Unknown")
                sensors.Add("IL2COD.C_TailwheelLock", "C_TailwheelLock : Unknown")
                sensors.Add("IL2COD.C_LandingFlap", "C_LandingFlap : Unknown")
                sensors.Add("IL2COD.C_LeadingEdgeSlats", "C_LeadingEdgeSlats : Unknown")
                sensors.Add("IL2COD.C_Undercarriage", "C_Undercarriage : Unknown")
                sensors.Add("IL2COD.C_UndercarriageEmergency", "C_UndercarriageEmergency : Unknown")
                sensors.Add("IL2COD.C_BombBayDoor", "C_BombBayDoor : Unknown")
                sensors.Add("IL2COD.C_Airbrake", "C_Airbrake : Unknown")
                sensors.Add("IL2COD.C_FuelTankSelector", "C_FuelTankSelector : Unknown")
                sensors.Add("IL2COD.C_TelepirometroElettrico", "C_TelepirometroElettrico : Unknown")
                sensors.Add("IL2COD.C_AltimeterPinion", "C_AltimeterPinion : Unknown")
                sensors.Add("IL2COD.C_AnemometroPinion", "C_AnemometroPinion : Unknown")
                sensors.Add("IL2COD.C_BombSight", "C_BombSight : Unknown")
                sensors.Add("IL2COD.C_Sight", "C_Sight : Unknown")
                sensors.Add("IL2COD.C_Bombenabwurfgerat", "C_Bombenabwurfgerat : Unknown")
                sensors.Add("IL2COD.C_KraftstoffSelector", "C_KraftstoffSelector : Unknown")
                sensors.Add("IL2COD.C_LiquidGauge0", "C_LiquidGauge0 : Unknown")
                sensors.Add("IL2COD.C_LiquidGauge1", "C_LiquidGauge1 : Unknown")
                sensors.Add("IL2COD.C_PriLights", "C_PriLights : Unknown")
                sensors.Add("IL2COD.C_SecLights", "C_SecLights : Unknown")
                sensors.Add("IL2COD.C_SightLights", "C_SightLights : Unknown")
                sensors.Add("IL2COD.C_PitotHeater", "C_PitotHeater : Unknown")
                sensors.Add("IL2COD.C_Handpumpe", "C_Handpumpe : Unknown")
                sensors.Add("IL2COD.C_RadTXRX", "C_RadTXRX : Unknown")
                sensors.Add("IL2COD.C_RadPriNav", "C_RadPriNav : Unknown")
                sensors.Add("IL2COD.C_RadSecNav", "C_RadSecNav : Unknown")
                sensors.Add("IL2COD.C_Kurssteuerung", "C_Kurssteuerung : Unknown")
                sensors.Add("IL2COD.A_Steering", "A_Steering : Unknown")
                sensors.Add("IL2COD.A_Brake", "A_Brake : Unknown")
                sensors.Add("IL2COD.A_Aileron", "A_Aileron : Unknown")
                sensors.Add("IL2COD.A_Elevator", "A_Elevator : Unknown")
                sensors.Add("IL2COD.A_Rudder", "A_Rudder : Unknown")
                sensors.Add("IL2COD.A_AileronTrim", "A_AileronTrim : Unknown")
                sensors.Add("IL2COD.A_ElevatorTrim", "A_ElevatorTrim : Unknown")
                sensors.Add("IL2COD.A_RudderTrim", "A_RudderTrim : Unknown")
                sensors.Add("IL2COD.A_Undercarriage", "A_Undercarriage : Unknown")
                sensors.Add("IL2COD.A_Undercarriage2", "A_Undercarriage2 : Unknown")
                sensors.Add("IL2COD.A_UndercarriageShock", "A_UndercarriageShock : Unknown")
                sensors.Add("IL2COD.A_UndercarriageWheel", "A_UndercarriageWheel : Unknown")
                sensors.Add("IL2COD.A_HatchDoor", "A_HatchDoor : Unknown")
                sensors.Add("IL2COD.A_BombBayDoor", "A_BombBayDoor : Unknown")
                sensors.Add("IL2COD.A_ImpellerAngle", "A_ImpellerAngle : Unknown")
                sensors.Add("IL2COD.A_ImpellerAngularVelocity", "A_ImpellerAngularVelocity : Unknown")
                sensors.Add("IL2COD.A_ImpellerUnfold", "A_ImpellerUnfold : Unknown")
                sensors.Add("IL2COD.A_LandingFlap", "A_LandingFlap : Unknown")
                sensors.Add("IL2COD.A_Airbrake", "A_Airbrake : Unknown")
                sensors.Add("IL2COD.A_EngineAirRadiator", "A_EngineAirRadiator : Unknown")
                sensors.Add("IL2COD.A_EngineWaterRadiator", "A_EngineWaterRadiator : Unknown")
                sensors.Add("IL2COD.A_EngineOilRadiator", "A_EngineOilRadiator : Unknown")
                sensors.Add("IL2COD.A_LeadingEdgeSlat", "A_LeadingEdgeSlat : Unknown")
                sensors.Add("IL2COD.Z_Coordinates", "Z_Coordinates : Unknown")
                sensors.Add("IL2COD.Z_Orientation", "Z_Orientation : Unknown")
                sensors.Add("IL2COD.Z_Orientation2", "Z_Orientation2 : Unknown")
                sensors.Add("IL2COD.Z_Orientation3", "Z_Orientation3 : Unknown")
                sensors.Add("IL2COD.Z_Overload", "Z_Overload : Unknown")
                sensors.Add("IL2COD.Z_AltitudeAGL", "Z_AltitudeAGL : Unknown")
                sensors.Add("IL2COD.Z_AltitudeMSL", "Z_AltitudeMSL : Unknown")
                sensors.Add("IL2COD.Z_VelocityIAS", "Z_VelocityIAS : Unknown")
                sensors.Add("IL2COD.Z_VelocityTAS", "Z_VelocityTAS : Unknown")
                sensors.Add("IL2COD.Z_VelocityMach", "Z_VelocityMach : Unknown")
                sensors.Add("IL2COD.Z_AmbientAirTemperature", "Z_AmbientAirTemperature : Unknown")
                sensors.Add("IL2COD.S_ElectricVoltage", "S_ElectricVoltage : Unknown")
                sensors.Add("IL2COD.S_ElectricIncandescingRatio", "S_ElectricIncandescingRatio : Unknown")
                sensors.Add("IL2COD.S_ElectricAmperage", "S_ElectricAmperage : Unknown")
                sensors.Add("IL2COD.S_ElectricPrimaryPitLight", "S_ElectricPrimaryPitLight : Unknown")
                sensors.Add("IL2COD.S_ElectricSecondaryPitLight", "S_ElectricSecondaryPitLight : Unknown")
                sensors.Add("IL2COD.S_ElectricSightLight", "S_ElectricSightLight : Unknown")
                sensors.Add("IL2COD.S_FuelReserve", "S_FuelReserve : Unknown")
                sensors.Add("IL2COD.S_HatchDoor", "S_HatchDoor : Unknown")
                sensors.Add("IL2COD.S_UndercarriageValve", "S_UndercarriageValve : Unknown")
                sensors.Add("IL2COD.S_PneumoContainerPressure", "S_PneumoContainerPressure : Unknown")
                sensors.Add("IL2COD.S_PneumoLinePressure", "S_PneumoLinePressure : Unknown")
                sensors.Add("IL2COD.S_HydroPressure", "S_HydroPressure : Unknown")
                sensors.Add("IL2COD.S_HydroReserve", "S_HydroReserve : Unknown")
                sensors.Add("IL2COD.S_Sturzanlage", "S_Sturzanlage : Unknown")
                sensors.Add("IL2COD.S_GunOperation", "S_GunOperation : Unknown")
                sensors.Add("IL2COD.S_GunReserve", "S_GunReserve : Unknown")
                sensors.Add("IL2COD.S_GunReserve2", "S_GunReserve2 : Unknown")
                sensors.Add("IL2COD.S_GunReserve3", "S_GunReserve3 : Unknown")
                sensors.Add("IL2COD.S_GunReserve4", "S_GunReserve4 : Unknown")
                sensors.Add("IL2COD.S_GunClipReserve", "S_GunClipReserve : Unknown")
                sensors.Add("IL2COD.S_BombReserve", "S_BombReserve : Unknown")
                sensors.Add("IL2COD.S_Fenster", "S_Fenster : Unknown")
                sensors.Add("IL2COD.S_PitotHeater", "S_PitotHeater : Unknown")
                sensors.Add("IL2COD.S_Bombenabwurfgerat", "S_Bombenabwurfgerat : Unknown")
                sensors.Add("IL2COD.S_Turret", "S_Turret : Unknown")
                sensors.Add("IL2COD.I_Timer", "I_Timer : Unknown")
                sensors.Add("IL2COD.I_AmbientTemp", "I_AmbientTemp : Unknown")
                sensors.Add("IL2COD.I_EngineRPM", "I_EngineRPM : Unknown")
                sensors.Add("IL2COD.I_EngineRPM2", "I_EngineRPM2 : Unknown")
                sensors.Add("IL2COD.I_EngineManPress", "I_EngineManPress : Unknown")
                sensors.Add("IL2COD.I_EngineManPress2", "I_EngineManPress2 : Unknown")
                sensors.Add("IL2COD.I_EngineBoostPress", "I_EngineBoostPress : Unknown")
                sensors.Add("IL2COD.I_EngineBoostPress2", "I_EngineBoostPress2 : Unknown")
                sensors.Add("IL2COD.I_EngineWatPress", "I_EngineWatPress : Unknown")
                sensors.Add("IL2COD.I_EngineWatPress2", "I_EngineWatPress2 : Unknown")
                sensors.Add("IL2COD.I_EngineOilPress", "I_EngineOilPress : Unknown")
                sensors.Add("IL2COD.I_EngineOilPress2", "I_EngineOilPress2 : Unknown")
                sensors.Add("IL2COD.I_EngineFuelPress", "I_EngineFuelPress : Unknown")
                sensors.Add("IL2COD.I_EngineFuelPress2", "I_EngineFuelPress2 : Unknown")
                sensors.Add("IL2COD.I_EngineWatTemp", "I_EngineWatTemp : Unknown")
                sensors.Add("IL2COD.I_EngineWatTemp2", "I_EngineWatTemp2 : Unknown")
                sensors.Add("IL2COD.I_EngineRadTemp", "I_EngineRadTemp : Unknown")
                sensors.Add("IL2COD.I_EngineRadTemp2", "I_EngineRadTemp2 : Unknown")
                sensors.Add("IL2COD.I_EngineOilTemp", "I_EngineOilTemp : Unknown")
                sensors.Add("IL2COD.I_EngineOilTemp2", "I_EngineOilTemp2 : Unknown")
                sensors.Add("IL2COD.I_EngineOilRadiatorTemp", "I_EngineOilRadiatorTemp : Unknown")
                sensors.Add("IL2COD.I_EngineOilRadiatorTemp2", "I_EngineOilRadiatorTemp2 : Unknown")
                sensors.Add("IL2COD.I_EngineTemperature", "I_EngineTemperature : Unknown")
                sensors.Add("IL2COD.I_EngineTemperature2", "I_EngineTemperature2 : Unknown")
                sensors.Add("IL2COD.I_EngineCarbTemp", "I_EngineCarbTemp : Unknown")
                sensors.Add("IL2COD.I_EngineCarbTemp2", "I_EngineCarbTemp2 : Unknown")
                sensors.Add("IL2COD.I_Pitch", "I_Pitch : Unknown")
                sensors.Add("IL2COD.I_Pitch2", "I_Pitch2 : Unknown")
                sensors.Add("IL2COD.I_VelocityIAS", "I_VelocityIAS : Unknown")
                sensors.Add("IL2COD.I_Altitude", "I_Altitude : Unknown")
                sensors.Add("IL2COD.I_Variometer", "I_Variometer : Unknown")
                sensors.Add("IL2COD.I_Slip", "I_Slip : Unknown")
                sensors.Add("IL2COD.I_MagneticCompass", "I_MagneticCompass : Unknown")
                sensors.Add("IL2COD.I_RepeaterCompass", "I_RepeaterCompass : Unknown")
                sensors.Add("IL2COD.I_Peilzeiger", "I_Peilzeiger : Unknown")
                sensors.Add("IL2COD.I_FuelReserve", "I_FuelReserve : Unknown")
                sensors.Add("IL2COD.I_LiquidReserve", "I_LiquidReserve : Unknown")
                sensors.Add("IL2COD.I_Voltamperemeter", "I_Voltamperemeter : Unknown")
                sensors.Add("IL2COD.I_Voltmeter", "I_Voltmeter : Unknown")
                sensors.Add("IL2COD.I_Amperemeter", "I_Amperemeter : Unknown")
                sensors.Add("IL2COD.I_HydroPressure", "I_HydroPressure : Unknown")
                sensors.Add("IL2COD.I_HydroEmPressure", "I_HydroEmPressure : Unknown")
                sensors.Add("IL2COD.I_Turn", "I_Turn : Unknown")
                sensors.Add("IL2COD.I_AH", "I_AH : Unknown")
                sensors.Add("IL2COD.I_DirectionIndicator", "I_DirectionIndicator : Unknown")
                sensors.Add("IL2COD.I_SlavedCompass", "I_SlavedCompass : Unknown")
                sensors.Add("IL2COD.I_Suction", "I_Suction : Unknown")
                sensors.Add("IL2COD.I_AFN", "I_AFN : Unknown")
                sensors.Add("IL2COD.I_ADF", "I_ADF : Unknown")
                sensors.Add("IL2COD.I_RDF", "I_RDF : Unknown")
                sensors.Add("IL2COD.I_RMI", "I_RMI : Unknown")
                sensors.Add("IL2COD.I_FLRC", "I_FLRC : Unknown")
                sensors.Add("IL2COD.I_Kurssteuerung", "I_Kurssteuerung : Unknown")
                sensors.Add("IL2COD.I_BombSight", "I_BombSight : Unknown")

            End Try

            For Each d As DictionaryEntry In td
                sensors.Add("IL2COD." & d.Key, d.Key & ": " & d.Value)
            Next

            Return sensors
        Catch ex As Exception
            objHost.DebugMessage("Error loading sensors:" & ex.Message & ": " & ex.StackTrace)
            'MsgBox(ex.Message & ":: " & ex.StackTrace)
        End Try
    End Function

    Function LCDSys2_AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_AvailableSensors
        Return AvailableSensors(pluginOptions)
    End Function

    Function SensorHasCustomDraw(sensor_name As String) As Boolean Implements GOverlayPlugin.Interfaces.IPlugin.SensorHasCustomDraw
        'All sensors are drawn with GOverlay default drawing
        Return False
    End Function

    Function ComboBoxes() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.ComboBoxes
        'Create custom ComboBox for your configuration to use
        Dim boxes As New Hashtable
        Dim myboxOptions As New Hashtable
        'Set each one of the Combobox options as value, Display Name
        Return boxes
    End Function

    Public Function SetDefaultOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.SetDefaultOptions
        'Set the default values you want to have on your sensor when its created, if the user doesnt change any option, he will have this settings
        Return elementData
    End Function

    Public Function CreateOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CreateOptions
        'Set the options the user will have when clicking on the element
        'The available option_types are:
        'Text: Input text
        'Combo3: Combo with options (Enabled=0, Disabled=1)
        'Sensors: Combo with available sensors
        'ColorBasic: Combo with basic colors for the regular text font
        'ColorRGB: Combo with common RGB colors = 16bitinteger
        'ComboOnOff: Combo with options (Disabled=0, Enabled=1)
        'ComboYesNo: Combo with options (Yes=Yes, No=No)
        'TextSize: Combo with options (Extra Small=4, Very Small=5, Small=10, Normal=15, Big=20, Very Big=30, Extreme=40)
        'FontStyle2: Combo with options (Regular Font=0, Square Font=1, Numbers Font 1=2
        'Orientation: Combo with options (Horizontal=0, Vertical=1)
        'Here you can also load your custom comboboxes
        Return New Hashtable

    End Function

    Public Function LCDSys2_CreateOptions(sensorId As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_CreateOptions
        'Set the options the user will have when clicking on the element
        'The available option_types are:
        'Text: Input text
        'Combo3: Combo with options (Enabled=0, Disabled=1)
        'Sensors: Combo with available sensors
        'ColorRGB: Combo with common RGB colors = 16bitinteger
        'ComboOnOff: Combo with options (Disabled=0, Enabled=1)
        'ComboYesNo: Combo with options (Yes=Yes, No=No)
        'FontStyle: Combo with options of the fonts the user has installed
        'Orientation: Combo with options (Horizontal=0, Vertical=1)
        'Alignment: Left=-1,Center=0,Right=1
        'Here you can also load your custom comboboxes

        'No options because GOverlay draws instead of us
        Return New Hashtable
    End Function

    Public Function PluginOptionsDefault() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptionsDefault
        'Set the default values you want to have on plugin, if the user doesnt change any option, he will have this settings
        Dim options As New Hashtable
        options("reqimages") = "*.*.plugin_il2cod_*"
        Return options
    End Function
    Public Function PluginOptions(pluginCurrentOptions As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptions
        'Set the options the user will have when going to the plugins tab and clicking on your plugin
        'The availalbe option_type are teh same as CreateOptions function
        Dim options As New Hashtable
        'Option: option_index as integer, option_data as ArrayList
        'Option_Data: option_type as string, option_label as string, option_name as string (no spaces, no _)
        'options.Add(0, New ArrayList({"Text", "Registry Path", "regkey"}))
        options.Add(0, New ArrayList({"TextMulti", "Images Match finder", "reqimages"}))
        options.Add(1, New ArrayList({"Button", "Upload Images", "reqimagesbutton"}))
        Return options
    End Function

    Public Function DisplayOnLCD(sensorId As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.DisplayOnLCD
        Return New ArrayList()
    End Function

    Public Function LCDSys2_DisplayOnLCD(sensorId As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_DisplayOnLCD
        'GOverlay draws instead of us
        Return New ArrayList
    End Function

    Public Function percToDeg(perc)
        Return perc * 360
    End Function

    Public Function percToRad(perc)
        Return degToRad(percToDeg(perc))
    End Function

    Public Function degToRad(deg)
        Return deg * Math.PI / 180
    End Function

    Public Function convertcolorto16bit(cr, cg, cb)

        Dim R As Double
        Dim G As Double
        Dim B As Double

        R = cr / 256 * 32
        G = cg / 256 * 64
        B = cb / 256 * 32

        R = Math.Floor(R)
        G = Math.Floor(G)
        B = Math.Floor(B)

        Dim final As Int32 = (CInt(R) << 11)
        final = final + Int(G << 5)
        final = final + Int(B)

        Return final

    End Function


    Private Function GrabData()

        If Me.FileMapView Is Nothing Then
            objHost.DebugMessage("IL2: FileMap empty, loading view")
            Me.IL2CoDFile = MemoryMappedFile.OpenExisting("CLODDeviceLink")
            Me.FileMapView = Me.IL2CoDFile.CreateViewAccessor()
        End If

        Dim slot0 = -1
        Dim slot1 = 0
        Dim slot2 = 1
        Dim slot3 = 2
        Dim slot4 = 3

        td("M_Random") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Random) * 10) + slot1) * 8))
        td("M_Shake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Shake) * 10) + slot1) * 8))
        td("M_CabinDamage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_CabinDamage) * 10) + slot1) * 8))
        td("M_CabinState") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_CabinState) * 10) + slot1) * 8))
        td("M_NamedDamage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_NamedDamage) * 10) + slot1) * 8))
        td("M_SystemWear") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_SystemWear) * 10) + slot1) * 8))
        td("M_Health") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Health) * 10) + slot1) * 8))
        td("C_Steering") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Steering) * 10) + slot1) * 8))
        td("C_Brake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Brake) * 10) + slot1) * 8))
        td("C_Throttle") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Throttle) * 10) + slot1) * 8))
        td("C_Trigger") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Trigger) * 10) + slot1) * 8))
        td("C_Trigger2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Trigger) * 10) + slot2) * 8))
        td("C_Pitch") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Pitch) * 10) + slot1) * 8))
        td("C_Mix") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Mix) * 10) + slot1) * 8))
        td("C_WaterRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_WaterRadiator) * 10) + slot1) * 8))
        td("C_OilRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_OilRadiator) * 10) + slot1) * 8))
        td("C_RadiatorAutomation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadiatorAutomation) * 10) + slot1) * 8))
        td("C_PitchAutomation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PitchAutomation) * 10) + slot1) * 8))
        td("C_Compressor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Compressor) * 10) + slot1) * 8))
        td("C_Afterburner") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Afterburner) * 10) + slot1) * 8))
        td("C_BoostEnabler") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BoostEnabler) * 10) + slot1) * 8))
        td("C_SlowRunningCutOut") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SlowRunningCutOut) * 10) + slot1) * 8))
        td("C_Magneto") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Magneto) * 10) + slot1) * 8))
        td("C_Feather") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Feather) * 10) + slot1) * 8))
        td("C_CarbHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_CarbHeater) * 10) + slot1) * 8))
        td("C_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_HatchDoor) * 10) + slot1) * 8))
        td("C_HatchJettison") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_HatchJettison) * 10) + slot1) * 8))
        td("C_Timer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Timer) * 10) + slot1) * 8))
        td("C_Timer1") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Timer1) * 10) + slot1) * 8))
        td("C_Aileron") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Aileron) * 10) + slot1) * 8))
        td("C_Elevator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Elevator) * 10) + slot1) * 8))
        td("C_Rudder") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Rudder) * 10) + slot1) * 8))
        td("C_AileronTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AileronTrim) * 10) + slot1) * 8))
        td("C_ElevatorTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_ElevatorTrim) * 10) + slot1) * 8))
        td("C_RudderTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RudderTrim) * 10) + slot1) * 8))
        td("C_TailwheelLock") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_TailwheelLock) * 10) + slot1) * 8))
        td("C_LandingFlap") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LandingFlap) * 10) + slot1) * 8))
        td("C_LeadingEdgeSlats") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LeadingEdgeSlats) * 10) + slot1) * 8))

        td("C_Undercarriage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Undercarriage) * 10) + slot0) * 8))
        td("C_UndercarriageEmergency") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_UndercarriageEmergency) * 10) + slot0) * 8))
        td("C_BombBayDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BombBayDoor) * 10) + slot0) * 8))
        td("C_Airbrake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Airbrake) * 10) + slot0) * 8))

        td("C_FuelTankSelector") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_FuelTankSelector) * 10) + slot1) * 8))
        td("C_TelepirometroElettrico") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_TelepirometroElettrico) * 10) + slot1) * 8))

        td("C_AltimeterPinion") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AltimeterPinion) * 10) + slot0) * 8))
        'MsgBox(td("C_AltimeterPinion"))
        td("C_AnemometroPinion") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AnemometroPinion) * 10) + slot0) * 8))
        td("C_BombSight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BombSight) * 10) + slot0) * 8))

        td("C_Sight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Sight) * 10) + slot3) * 8))

        td("C_Bombenabwurfgerat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Bombenabwurfgerat) * 10) + slot0) * 8))
        td("C_KraftstoffSelector") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_KraftstoffSelector) * 10) + slot0) * 8))
        td("C_LiquidGauge0") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LiquidGauge0) * 10) + slot0) * 8))
        td("C_LiquidGauge1") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LiquidGauge1) * 10) + slot0) * 8))

        td("C_PriLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PriLights) * 10) + slot1) * 8))
        td("C_SecLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SecLights) * 10) + slot1) * 8))
        td("C_SightLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SightLights) * 10) + slot1) * 8))

        td("C_PitotHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PitotHeater) * 10) + slot0) * 8))
        td("C_Handpumpe") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Handpumpe) * 10) + slot0) * 8))
        td("C_RadTXRX") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadTXRX) * 10) + slot0) * 8))
        td("C_RadPriNav") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadPriNav) * 10) + slot0) * 8))
        td("C_RadSecNav") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadSecNav) * 10) + slot0) * 8))
        td("C_Kurssteuerung") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Kurssteuerung) * 10) + slot0) * 8))
        td("A_Steering") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Steering) * 10) + slot0) * 8))
        td("A_Brake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Brake) * 10) + slot0) * 8))
        td("A_Aileron") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Aileron) * 10) + slot0) * 8))
        td("A_Elevator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Elevator) * 10) + slot0) * 8))
        td("A_Rudder") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Rudder) * 10) + slot0) * 8))
        td("A_AileronTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_AileronTrim) * 10) + slot0) * 8))
        td("A_ElevatorTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ElevatorTrim) * 10) + slot0) * 8))
        td("A_RudderTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_RudderTrim) * 10) + slot0) * 8))

        td("A_Undercarriage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Undercarriage) * 10) + slot1) * 8))
        td("A_Undercarriage2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Undercarriage) * 10) + slot2) * 8))

        td("A_UndercarriageShock") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_UndercarriageShock) * 10) + slot1) * 8))
        td("A_UndercarriageWheel") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_UndercarriageWheel) * 10) + slot1) * 8))

        td("A_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_HatchDoor) * 10) + slot1) * 8))

        td("A_BombBayDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_BombBayDoor) * 10) + slot0) * 8))
        td("A_ImpellerAngle") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerAngle) * 10) + slot0) * 8))
        td("A_ImpellerAngularVelocity") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerAngularVelocity) * 10) + slot0) * 8))
        td("A_ImpellerUnfold") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerUnfold) * 10) + slot0) * 8))
        td("A_LandingFlap") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_LandingFlap) * 10) + slot0) * 8))
        td("A_Airbrake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Airbrake) * 10) + slot0) * 8))

        td("A_EngineAirRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineAirRadiator) * 10) + slot1) * 8))
        td("A_EngineWaterRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineWaterRadiator) * 10) + slot1) * 8))
        td("A_EngineOilRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineOilRadiator) * 10) + slot1) * 8))
        td("A_LeadingEdgeSlat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_LeadingEdgeSlat) * 10) + slot1) * 8))

        td("Z_Coordinates") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Coordinates) * 10) + slot0) * 8))

        td("Z_Orientation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Orientation) * 10) + slot1) * 8))
        td("Z_Orientation2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Orientation) * 10) + slot2) * 8))
        td("Z_Orientation3") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Orientation) * 10) + slot3) * 8))

        td("Z_Overload") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Overload) * 10) + slot0) * 8))
        td("Z_AltitudeAGL") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AltitudeAGL) * 10) + slot0) * 8))
        td("Z_AltitudeMSL") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AltitudeMSL) * 10) + slot0) * 8))
        td("Z_VelocityIAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityIAS) * 10) + slot0) * 8))
        td("Z_VelocityTAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityTAS) * 10) + slot0) * 8))
        td("Z_VelocityMach") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityMach) * 10) + slot0) * 8))
        td("Z_AmbientAirTemperature") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AmbientAirTemperature) * 10) + slot0) * 8))
        td("S_ElectricVoltage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricVoltage) * 10) + slot0) * 8))
        td("S_ElectricIncandescingRatio") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricIncandescingRatio) * 10) + slot0) * 8))
        td("S_ElectricAmperage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricAmperage) * 10) + slot0) * 8))

        td("S_ElectricPrimaryPitLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricPrimaryPitLight) * 10) + slot1) * 8))
        td("S_ElectricSecondaryPitLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricSecondaryPitLight) * 10) + slot1) * 8))
        td("S_ElectricSightLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricSightLight) * 10) + slot1) * 8))
        td("S_FuelReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_FuelReserve) * 10) + slot1) * 8))

        td("S_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HatchDoor) * 10) + slot0) * 8))
        td("S_UndercarriageValve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_UndercarriageValve) * 10) + slot0) * 8))
        td("S_PneumoContainerPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PneumoContainerPressure) * 10) + slot0) * 8))
        td("S_PneumoLinePressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PneumoLinePressure) * 10) + slot0) * 8))
        td("S_HydroPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HydroPressure) * 10) + slot0) * 8))
        td("S_HydroReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HydroReserve) * 10) + slot0) * 8))
        td("S_Sturzanlage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Sturzanlage) * 10) + slot0) * 8))
        td("S_GunOperation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunOperation) * 10) + slot0) * 8))

        td("S_GunReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunReserve) * 10) + slot1) * 8))
        td("S_GunReserve2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunReserve) * 10) + slot2) * 8))
        td("S_GunReserve3") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunReserve) * 10) + slot3) * 8))
        td("S_GunReserve4") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunReserve) * 10) + slot4) * 8))

        td("S_GunClipReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunClipReserve) * 10) + slot0) * 8))
        td("S_BombReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_BombReserve) * 10) + slot0) * 8))
        td("S_Fenster") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Fenster) * 10) + slot0) * 8))
        td("S_PitotHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PitotHeater) * 10) + slot0) * 8))
        td("S_Bombenabwurfgerat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Bombenabwurfgerat) * 10) + slot0) * 8))
        td("S_Turret") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Turret) * 10) + slot0) * 8))

        td("I_Timer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Timer) * 10) + slot0) * 8))
        td("I_AmbientTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AmbientTemp) * 10) + slot0) * 8))

        td("I_EngineRPM") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRPM) * 10) + slot1) * 8))
        td("I_EngineRPM2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRPM) * 10) + slot1) * 8))

        td("I_EngineManPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineManPress) * 10) + slot1) * 8))
        td("I_EngineManPress2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineManPress) * 10) + slot2) * 8))

        td("I_EngineBoostPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineBoostPress) * 10) + slot1) * 8))
        td("I_EngineBoostPress2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineBoostPress) * 10) + slot2) * 8))

        td("I_EngineWatPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatPress) * 10) + slot1) * 8))
        td("I_EngineWatPress2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatPress) * 10) + slot2) * 8))

        td("I_EngineOilPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilPress) * 10) + slot1) * 8))
        td("I_EngineOilPress2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilPress) * 10) + slot2) * 8))

        td("I_EngineFuelPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineFuelPress) * 10) + slot1) * 8))
        td("I_EngineFuelPress2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineFuelPress) * 10) + slot2) * 8))

        td("I_EngineWatTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatTemp) * 10) + slot1) * 8))
        td("I_EngineWatTemp2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatTemp) * 10) + slot2) * 8))

        td("I_EngineRadTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRadTemp) * 10) + slot1) * 8))
        td("I_EngineRadTemp2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRadTemp) * 10) + slot2) * 8))

        td("I_EngineOilTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilTemp) * 10) + slot1) * 8))
        td("I_EngineOilTemp2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilTemp) * 10) + slot2) * 8))

        td("I_EngineOilRadiatorTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilRadiatorTemp) * 10) + slot1) * 8))
        td("I_EngineOilRadiatorTemp2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilRadiatorTemp) * 10) + slot2) * 8))

        td("I_EngineTemperature") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineTemperature) * 10) + slot1) * 8))
        td("I_EngineTemperature2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineTemperature) * 10) + slot2) * 8))

        td("I_EngineCarbTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineCarbTemp) * 10) + slot1) * 8))
        td("I_EngineCarbTemp2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineCarbTemp) * 10) + slot2) * 8))

        td("I_Pitch") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Pitch) * 10) + slot1) * 8))
        td("I_Pitch2") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Pitch) * 10) + slot2) * 8))


        td("I_VelocityIAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_VelocityIAS) * 10) + slot0) * 8))
        td("I_Altitude") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Altitude) * 10) + slot0) * 8))
        td("I_Variometer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Variometer) * 10) + slot0) * 8))
        td("I_Slip") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Slip) * 10) + slot0) * 8))
        td("I_MagneticCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_MagneticCompass) * 10) + slot0) * 8))
        td("I_RepeaterCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RepeaterCompass) * 10) + slot0) * 8))
        td("I_Peilzeiger") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Peilzeiger) * 10) + slot0) * 8))
        td("I_FuelReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_FuelReserve) * 10) + slot0) * 8))
        td("I_LiquidReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_LiquidReserve) * 10) + slot0) * 8))
        td("I_Voltamperemeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Voltamperemeter) * 10) + slot0) * 8))
        td("I_Voltmeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Voltmeter) * 10) + slot0) * 8))
        td("I_Amperemeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Amperemeter) * 10) + slot0) * 8))
        td("I_HydroPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_HydroPressure) * 10) + slot0) * 8))
        td("I_HydroEmPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_HydroEmPressure) * 10) + slot0) * 8))
        td("I_Turn") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Turn) * 10) + slot0) * 8))
        td("I_AH") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AH) * 10) + slot0) * 8))
        td("I_DirectionIndicator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_DirectionIndicator) * 10) + slot0) * 8))
        td("I_SlavedCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_SlavedCompass) * 10) + slot0) * 8))
        td("I_Suction") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Suction) * 10) + slot0) * 8))
        td("I_AFN") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AFN) * 10) + slot0) * 8))
        td("I_ADF") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_ADF) * 10) + slot0) * 8))
        td("I_RDF") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RDF) * 10) + slot0) * 8))
        td("I_RMI") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RMI) * 10) + slot0) * 8))
        td("I_FLRC") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_FLRC) * 10) + slot0) * 8))
        td("I_Kurssteuerung") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Kurssteuerung) * 10) + slot0) * 8))
        td("I_BombSight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_BombSight) * 10) + slot0) * 8))

        Dim td2 = td.Clone

        Try
            Dim invalidvalue As Double = 1.96808407167164E+243
            For Each d As DictionaryEntry In td2
                If d.Value = invalidvalue Then
                    td(d.Key) = 0
                Else
                    td(d.Key) = Math.Round(d.Value, 2)
                End If
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Function

    Private Function GrabDataOLD()

        If Me.FileMapView Is Nothing Then
            objHost.DebugMessage("IL2: FileMap empty, loading view")
            Me.IL2CoDFile = MemoryMappedFile.OpenExisting("CLODDeviceLink")
            Me.FileMapView = Me.IL2CoDFile.CreateViewAccessor()
        End If

        td("M_Random") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Random) * 10) + 0) * 8))
        td("M_Shake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Shake) * 10) + 0) * 8))
        td("M_CabinDamage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_CabinDamage) * 10) + 0) * 8))
        td("M_CabinState") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_CabinState) * 10) + 0) * 8))
        td("M_NamedDamage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_NamedDamage) * 10) + 0) * 8))
        td("M_SystemWear") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_SystemWear) * 10) + 0) * 8))
        td("M_Health") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.M_Health) * 10) + 0) * 8))
        td("C_Steering") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Steering) * 10) + 0) * 8))
        td("C_Brake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Brake) * 10) + 0) * 8))
        td("C_Throttle") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Throttle) * 10) + 0) * 8))
        td("C_Trigger") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Trigger) * 10) + 0) * 8))
        td("C_Pitch") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Pitch) * 10) + 0) * 8))
        td("C_Mix") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Mix) * 10) + 0) * 8))
        td("C_WaterRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_WaterRadiator) * 10) + 0) * 8))
        td("C_OilRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_OilRadiator) * 10) + 0) * 8))
        td("C_RadiatorAutomation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadiatorAutomation) * 10) + 0) * 8))
        td("C_PitchAutomation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PitchAutomation) * 10) + 0) * 8))
        td("C_Compressor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Compressor) * 10) + 0) * 8))
        td("C_Afterburner") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Afterburner) * 10) + 0) * 8))
        td("C_BoostEnabler") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BoostEnabler) * 10) + 0) * 8))
        td("C_SlowRunningCutOut") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SlowRunningCutOut) * 10) + 0) * 8))
        td("C_Magneto") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Magneto) * 10) + 0) * 8))
        td("C_Feather") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Feather) * 10) + 0) * 8))
        td("C_CarbHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_CarbHeater) * 10) + 0) * 8))
        td("C_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_HatchDoor) * 10) + 0) * 8))
        td("C_HatchJettison") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_HatchJettison) * 10) + 0) * 8))
        td("C_Timer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Timer) * 10) + 0) * 8))
        td("C_Timer1") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Timer1) * 10) + 0) * 8))
        td("C_Aileron") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Aileron) * 10) + 0) * 8))
        td("C_Elevator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Elevator) * 10) + 0) * 8))
        td("C_Rudder") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Rudder) * 10) + 0) * 8))
        td("C_AileronTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AileronTrim) * 10) + 0) * 8))
        td("C_ElevatorTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_ElevatorTrim) * 10) + 0) * 8))
        td("C_RudderTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RudderTrim) * 10) + 0) * 8))
        td("C_TailwheelLock") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_TailwheelLock) * 10) + 0) * 8))
        td("C_LandingFlap") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LandingFlap) * 10) + 0) * 8))
        td("C_LeadingEdgeSlats") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LeadingEdgeSlats) * 10) + 0) * 8))
        td("C_Undercarriage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Undercarriage) * 10) + 0) * 8))
        td("C_UndercarriageEmergency") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_UndercarriageEmergency) * 10) + 0) * 8))
        td("C_BombBayDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BombBayDoor) * 10) + 0) * 8))
        td("C_Airbrake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Airbrake) * 10) + 0) * 8))
        td("C_FuelTankSelector") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_FuelTankSelector) * 10) + 0) * 8))
        td("C_TelepirometroElettrico") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_TelepirometroElettrico) * 10) + 0) * 8))
        td("C_AltimeterPinion") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AltimeterPinion) * 10) + -1) * 8))
        'MsgBox(td("C_AltimeterPinion"))
        td("C_AnemometroPinion") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_AnemometroPinion) * 10) + 0) * 8))
        td("C_BombSight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_BombSight) * 10) + 0) * 8))
        td("C_Sight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Sight) * 10) + 0) * 8))
        td("C_Bombenabwurfgerat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Bombenabwurfgerat) * 10) + 0) * 8))
        td("C_KraftstoffSelector") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_KraftstoffSelector) * 10) + 0) * 8))
        td("C_LiquidGauge0") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LiquidGauge0) * 10) + 0) * 8))
        td("C_LiquidGauge1") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_LiquidGauge1) * 10) + 0) * 8))
        td("C_PriLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PriLights) * 10) + 0) * 8))
        td("C_SecLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SecLights) * 10) + 0) * 8))
        td("C_SightLights") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_SightLights) * 10) + 0) * 8))
        td("C_PitotHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_PitotHeater) * 10) + 0) * 8))
        td("C_Handpumpe") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Handpumpe) * 10) + 0) * 8))
        td("C_RadTXRX") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadTXRX) * 10) + 0) * 8))
        td("C_RadPriNav") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadPriNav) * 10) + 0) * 8))
        td("C_RadSecNav") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_RadSecNav) * 10) + 0) * 8))
        td("C_Kurssteuerung") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.C_Kurssteuerung) * 10) + 0) * 8))
        td("A_Steering") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Steering) * 10) + 0) * 8))
        td("A_Brake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Brake) * 10) + 0) * 8))
        td("A_Aileron") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Aileron) * 10) + 0) * 8))
        td("A_Elevator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Elevator) * 10) + 0) * 8))
        td("A_Rudder") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Rudder) * 10) + 0) * 8))
        td("A_AileronTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_AileronTrim) * 10) + 0) * 8))
        td("A_ElevatorTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ElevatorTrim) * 10) + 0) * 8))
        td("A_RudderTrim") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_RudderTrim) * 10) + 0) * 8))
        td("A_Undercarriage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Undercarriage) * 10) + 0) * 8))
        td("A_UndercarriageShock") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_UndercarriageShock) * 10) + 0) * 8))
        td("A_UndercarriageWheel") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_UndercarriageWheel) * 10) + 0) * 8))
        td("A_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_HatchDoor) * 10) + 0) * 8))
        td("A_BombBayDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_BombBayDoor) * 10) + 0) * 8))
        td("A_ImpellerAngle") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerAngle) * 10) + 0) * 8))
        td("A_ImpellerAngularVelocity") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerAngularVelocity) * 10) + 0) * 8))
        td("A_ImpellerUnfold") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_ImpellerUnfold) * 10) + 0) * 8))
        td("A_LandingFlap") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_LandingFlap) * 10) + 0) * 8))
        td("A_Airbrake") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_Airbrake) * 10) + 0) * 8))
        td("A_EngineAirRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineAirRadiator) * 10) + 0) * 8))
        td("A_EngineWaterRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineWaterRadiator) * 10) + 0) * 8))
        td("A_EngineOilRadiator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_EngineOilRadiator) * 10) + 0) * 8))
        td("A_LeadingEdgeSlat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.A_LeadingEdgeSlat) * 10) + 0) * 8))
        td("Z_Coordinates") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Coordinates) * 10) + 0) * 8))
        td("Z_Orientation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Orientation) * 10) + 0) * 8))
        td("Z_Overload") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_Overload) * 10) + 0) * 8))
        td("Z_AltitudeAGL") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AltitudeAGL) * 10) + 0) * 8))
        td("Z_AltitudeMSL") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AltitudeMSL) * 10) + 0) * 8))
        td("Z_VelocityIAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityIAS) * 10) + 0) * 8))
        td("Z_VelocityTAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityTAS) * 10) + 0) * 8))
        td("Z_VelocityMach") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_VelocityMach) * 10) + 0) * 8))
        td("Z_AmbientAirTemperature") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.Z_AmbientAirTemperature) * 10) + 0) * 8))
        td("S_ElectricVoltage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricVoltage) * 10) + 0) * 8))
        td("S_ElectricIncandescingRatio") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricIncandescingRatio) * 10) + 0) * 8))
        td("S_ElectricAmperage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricAmperage) * 10) + 0) * 8))
        td("S_ElectricPrimaryPitLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricPrimaryPitLight) * 10) + 0) * 8))
        td("S_ElectricSecondaryPitLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricSecondaryPitLight) * 10) + 0) * 8))
        td("S_ElectricSightLight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_ElectricSightLight) * 10) + 0) * 8))
        td("S_FuelReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_FuelReserve) * 10) + 0) * 8))
        td("S_HatchDoor") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HatchDoor) * 10) + 0) * 8))
        td("S_UndercarriageValve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_UndercarriageValve) * 10) + 0) * 8))
        td("S_PneumoContainerPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PneumoContainerPressure) * 10) + 0) * 8))
        td("S_PneumoLinePressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PneumoLinePressure) * 10) + 0) * 8))
        td("S_HydroPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HydroPressure) * 10) + 0) * 8))
        td("S_HydroReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_HydroReserve) * 10) + 0) * 8))
        td("S_Sturzanlage") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Sturzanlage) * 10) + 0) * 8))
        td("S_GunOperation") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunOperation) * 10) + 0) * 8))
        td("S_GunReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunReserve) * 10) + 0) * 8))
        td("S_GunClipReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_GunClipReserve) * 10) + 0) * 8))
        td("S_BombReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_BombReserve) * 10) + 0) * 8))
        td("S_Fenster") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Fenster) * 10) + 0) * 8))
        td("S_PitotHeater") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_PitotHeater) * 10) + 0) * 8))
        td("S_Bombenabwurfgerat") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Bombenabwurfgerat) * 10) + 0) * 8))
        td("S_Turret") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.S_Turret) * 10) + 0) * 8))
        td("I_Timer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Timer) * 10) + 0) * 8))
        td("I_AmbientTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AmbientTemp) * 10) + 0) * 8))
        td("I_EngineRPM") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRPM) * 10) + 0) * 8))
        td("I_EngineManPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineManPress) * 10) + 0) * 8))
        td("I_EngineBoostPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineBoostPress) * 10) + 0) * 8))
        td("I_EngineWatPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatPress) * 10) + 0) * 8))
        td("I_EngineOilPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilPress) * 10) + 0) * 8))
        td("I_EngineFuelPress") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineFuelPress) * 10) + 0) * 8))
        td("I_EngineWatTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineWatTemp) * 10) + 0) * 8))
        td("I_EngineRadTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineRadTemp) * 10) + 0) * 8))
        td("I_EngineOilTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilTemp) * 10) + 0) * 8))
        td("I_EngineOilRadiatorTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineOilRadiatorTemp) * 10) + 0) * 8))
        td("I_EngineTemperature") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineTemperature) * 10) + 0) * 8))
        td("I_EngineCarbTemp") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_EngineCarbTemp) * 10) + 0) * 8))
        td("I_Pitch") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Pitch) * 10) + 0) * 8))
        td("I_VelocityIAS") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_VelocityIAS) * 10) + -1) * 8))
        td("I_Altitude") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Altitude) * 10) + -1) * 8))
        td("I_Variometer") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Variometer) * 10) + -1) * 8))
        td("I_Slip") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Slip) * 10) + -1) * 8))
        td("I_MagneticCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_MagneticCompass) * 10) + 0) * 8))
        td("I_RepeaterCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RepeaterCompass) * 10) + 0) * 8))
        td("I_Peilzeiger") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Peilzeiger) * 10) + 0) * 8))
        td("I_FuelReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_FuelReserve) * 10) + -1) * 8))
        td("I_LiquidReserve") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_LiquidReserve) * 10) + 0) * 8))
        td("I_Voltamperemeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Voltamperemeter) * 10) + 0) * 8))
        td("I_Voltmeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Voltmeter) * 10) + 0) * 8))
        td("I_Amperemeter") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Amperemeter) * 10) + 0) * 8))
        td("I_HydroPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_HydroPressure) * 10) + 0) * 8))
        td("I_HydroEmPressure") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_HydroEmPressure) * 10) + 0) * 8))
        td("I_Turn") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Turn) * 10) + -1) * 8))
        td("I_AH") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AH) * 10) + 0) * 8))
        td("I_DirectionIndicator") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_DirectionIndicator) * 10) + -1) * 8))
        td("I_SlavedCompass") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_SlavedCompass) * 10) + 0) * 8))
        td("I_Suction") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Suction) * 10) + 0) * 8))
        td("I_AFN") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_AFN) * 10) + 0) * 8))
        td("I_ADF") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_ADF) * 10) + 0) * 8))
        td("I_RDF") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RDF) * 10) + 0) * 8))
        td("I_RMI") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_RMI) * 10) + 0) * 8))
        td("I_FLRC") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_FLRC) * 10) + 0) * 8))
        td("I_Kurssteuerung") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_Kurssteuerung) * 10) + 0) * 8))
        td("I_BombSight") = Double.Parse(Me.FileMapView.ReadDouble(((CInt(E69IL2CoD.IL2CoDData.ParameterTypes.I_BombSight) * 10) + 0) * 8))

        Dim td2 = td.Clone

        Try
            Dim invalidvalue As Double = 1.96808407167164E+243
            For Each d As DictionaryEntry In td2
                If d.Value = invalidvalue Then
                    td(d.Key) = 0
                Else
                    td(d.Key) = Math.Round(d.Value, 2)
                End If
            Next
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

    End Function

#Region "Native API Signatures and Types"

    ''' <summary>
    ''' Access rights for file mapping objects
    ''' http://msdn.microsoft.com/en-us/library/aa366559.aspx
    ''' </summary>
    ''' <remarks></remarks>
    Public Enum FileMapAccess
        FILE_MAP_COPY = 1
        FILE_MAP_WRITE = 2
        FILE_MAP_READ = 4
        FILE_MAP_ALL_ACCESS = &HF001F
    End Enum


    ''' <summary>
    ''' Represents a wrapper class for a file mapping handle. 
    ''' </summary>
    ''' <remarks></remarks>
    <SuppressUnmanagedCodeSecurity(), _
    HostProtection(SecurityAction.LinkDemand, MayLeakOnAbort:=True)> _
    Friend NotInheritable Class SafeFileMappingHandle
        Inherits SafeHandleZeroOrMinusOneIsInvalid

        <SecurityPermission(SecurityAction.LinkDemand, UnmanagedCode:=True)> _
        Private Sub New()
            MyBase.New(True)
        End Sub

        <SecurityPermission(SecurityAction.LinkDemand, UnmanagedCode:=True)> _
        Public Sub New(ByVal handle As IntPtr, ByVal ownsHandle As Boolean)
            MyBase.New(ownsHandle)
            MyBase.SetHandle(handle)
        End Sub

        <ReliabilityContract(Consistency.WillNotCorruptState, Cer.Success), _
        DllImport("kernel32.dll", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Private Shared Function CloseHandle(ByVal handle As IntPtr) _
        As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function

        Protected Overrides Function ReleaseHandle() As Boolean
            Return SafeFileMappingHandle.CloseHandle(MyBase.handle)
        End Function

    End Class


    Friend ReadOnly INVALID_HANDLE_VALUE As New IntPtr(-1)


    ''' <summary>
    ''' The class exposes Windows APIs used in this code sample.
    ''' </summary>
    ''' <remarks></remarks>
    <SuppressUnmanagedCodeSecurity()> _
    Friend Class NativeMethod

        ''' <summary>
        ''' Opens a named file mapping object.
        ''' </summary>
        ''' <param name="dwDesiredAccess">
        ''' The access to the file mapping object. This access is checked against 
        ''' any security descriptor on the target file mapping object.
        ''' </param>
        ''' <param name="bInheritHandle">
        ''' If this parameter is TRUE, a process created by the CreateProcess 
        ''' function can inherit the handle; otherwise, the handle cannot be 
        ''' inherited.
        ''' </param>
        ''' <param name="lpName">
        ''' The name of the file mapping object to be opened.
        ''' </param>
        ''' <returns>
        ''' If the function succeeds, the return value is an open handle to the 
        ''' specified file mapping object.
        ''' </returns>
        <DllImport("kernel32.dll", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Public Shared Function OpenFileMapping( _
            ByVal dwDesiredAccess As FileMapAccess, _
            ByVal bInheritHandle As Boolean, _
            ByVal lpName As String) _
            As SafeFileMappingHandle
        End Function


        ''' <summary>
        ''' Maps a view of a file mapping into the address space of a calling 
        ''' process.
        ''' </summary>
        ''' <param name="hFileMappingObject">
        ''' A handle to a file mapping object. The CreateFileMapping and 
        ''' OpenFileMapping functions return this handle.
        ''' </param>
        ''' <param name="dwDesiredAccess">
        ''' The type of access to a file mapping object, which determines the 
        ''' protection of the pages.
        ''' </param>
        ''' <param name="dwFileOffsetHigh">
        ''' A high-order DWORD of the file offset where the view begins.
        ''' </param>
        ''' <param name="dwFileOffsetLow">
        ''' A low-order DWORD of the file offset where the view is to begin.
        ''' </param>
        ''' <param name="dwNumberOfBytesToMap">
        ''' The number of bytes of a file mapping to map to the view. All bytes 
        ''' must be within the maximum size specified by CreateFileMapping.
        ''' </param>
        ''' <returns>
        ''' If the function succeeds, the return value is the starting address of
        ''' the mapped view.
        ''' </returns>
        <DllImport("Kernel32.dll", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Public Shared Function MapViewOfFile( _
            ByVal hFileMappingObject As SafeFileMappingHandle, _
            ByVal dwDesiredAccess As FileMapAccess, _
            ByVal dwFileOffsetHigh As UInt32, _
            ByVal dwFileOffsetLow As UInt32, _
            ByVal dwNumberOfBytesToMap As UInt32) _
            As IntPtr
        End Function


        ''' <summary>
        ''' Unmaps a mapped view of a file from the calling process's address 
        ''' space.
        ''' </summary>
        ''' <param name="lpBaseAddress">
        ''' A pointer to the base address of the mapped view of a file that is to 
        ''' be unmapped.
        ''' </param>
        ''' <returns></returns>
        <DllImport("Kernel32.dll", CharSet:=CharSet.Auto, SetLastError:=True)> _
        Public Shared Function UnmapViewOfFile( _
            ByVal lpBaseAddress As IntPtr) _
            As <MarshalAs(UnmanagedType.Bool)> Boolean
        End Function

    End Class

#End Region
End Class