Option Strict Off
Imports System.Collections
Public Class Helper
    Dim pc As PluginClass

    Public Function addPluginOption(optionType As String, optionLabel As String, optionStoreName As String) As ArrayList
        'optionType:
        '   Text:           Input text
        '   Combo3:         Combo with options (Enabled=0, Disabled=1)
        '   Sensors:        Combo with available sensors
        '   ColorRGB:       Combo with common RGB colors = 16bitinteger
        '   ComboOnOff:     Combo with options (Disabled=0, Enabled=1)
        '   ComboYesNo:     Combo with options (Yes=Yes, No=No)
        '   FontStyle:      Combo with options of the fonts the user has installed
        '   Orientation:    Combo with options (Horizontal=0, Vertical=1)
        '   Alignment:      Left=-1,Center=0,Right=1

        'No spaces, no underscore
        optionStoreName = optionStoreName.Replace(" ", "")
        optionStoreName = optionStoreName.Replace("_", "")
        Return New ArrayList({optionType, optionLabel, optionStoreName})
    End Function


    Public Function lcd2_addLine(xpos As Integer, ypos As Integer, color As Integer) As ArrayList
        Return New ArrayList({xpos, ypos, color})
    End Function
End Class

Public Class PluginClass
    Implements GOverlayPlugin.Interfaces.IPlugin
    Public testvar As Integer = 1
    Public pluginId As String = "uniquePluginID#123213."
    Public pluginName As String = "GOverlay Example Plugin: Simple Draw"
    Public Helper As Helper = New Helper

    Private objHost As GOverlayPlugin.Interfaces.IHost

    Public Sub Initialize(ByVal Host As GOverlayPlugin.Interfaces.IHost) Implements GOverlayPlugin.Interfaces.IPlugin.Initialize
        objHost = Host
    End Sub



    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------NAME OF THE PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Name() As String Implements GOverlayPlugin.Interfaces.IPlugin.Name        
        'Return your plugin name
        Get
            Return pluginName
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DISPLAY THE PLUGIN APPLIES TO
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Display() As String Implements GOverlayPlugin.Interfaces.IPlugin.Display
        'Return the display this plugin belongs to
        Get
            Return "lcdsys"
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DESCRIPTION OF THE PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public ReadOnly Property Description() As String Implements GOverlayPlugin.Interfaces.IPlugin.Description
        'Return the display this plugin belongs to
        Get
            Return "This plugin performs a simple draw (done by goverlay itself), so it actually just gathers sensors."
        End Get
    End Property

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------COMBO BOXES FOR USE IN YOUR PLUGIN (EITHER ELEMENTS OPTIONS OR PLUGIN OPTIONS)
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function ComboBoxes() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.ComboBoxes
        'Create custom ComboBox for your configuration to use
        Dim boxes As New Hashtable
        Dim myboxOptions As New Hashtable
        myboxOptions.Add("celsius", "Celsius Unit")
        myboxOptions.Add("fahrenheit", "Fahrenheit Unit")

        boxes.Add(pluginId & "unit", myboxOptions)
        Return boxes
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------PLUGIN OPTIONS LIST FOR THE USER TO CONFIGURE
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function PluginOptions(pluginCurrentOptions As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptions
        Dim options As New Hashtable
        'Option: option_index as integer, option_data as ArrayList
        'Option_Data: option_type as string, option_label as string, option_name as string (no spaces, no _)
        options.Add(0, Helper.addPluginOption("Text", "A note", "note"))
        options.Add(1, Helper.addPluginOption(pluginId & "unit", "Type of unit to use", "unit"))
        Return options
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------PLUGIN DEFAULT OPTIONS WHEN INSTALLED
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function PluginOptionsDefault() As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.PluginOptionsDefault
        'Set the default values you want to have on plugin, if the user doesnt change any option, he will have this settings
        Dim options As New Hashtable
        options("unit") = "celsius"
        options("note") = "for demo purposes"
        Return options
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------LIST OF AVAILABLE ELEMENTS OF YOUR PLUGIN
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.AvailableSensors
        'Create the list of the sensors/elements this plugin has
        'You can access your pluginOptions here as pluginOptions(your_option)    

        objHost.DebugMessage("DemoPlugin - Listing the plugin elements available")

        Dim selectedUnit As String = pluginOptions("unit")

        'Options: SensorTag, Sensor Display-Name
        Dim sensors As New System.Collections.Generic.Dictionary(Of String, String)

        sensors.Add(pluginId & "temp", "Temperature (in " & selectedUnit & ")")
        sensors.Add(pluginId & "usage", "Usage")

        Return sensors
    End Function

    Function LCDSys2_AvailableSensors(pluginOptions As Hashtable) As System.Collections.Generic.Dictionary(Of String, String) Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_AvailableSensors
        Return AvailableSensors(pluginOptions)
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------SPECIFY FOR EACH SENSOR IF IT HAS A CUSTOM DRAW
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function SensorHasCustomDraw(sensor_name As String) As Boolean Implements GOverlayPlugin.Interfaces.IPlugin.SensorHasCustomDraw
        'All sensors are drawn with GOverlay default drawing
        If (sensor_name = pluginId & "temp" Or sensor_name = pluginId & "usage") Then
            Return False
        End If
        Return False
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------EACH PLUGIN ELEMENT OPTION FOR THE USER TO CONFIGURE
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function CreateOptions(sensor_name As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CreateOptions
        'No options because GOverlay draws instead of us
        Return New Hashtable
    End Function

    Public Function LCDSys2_CreateOptions(sensor_name As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_CreateOptions
        'No options because GOverlay draws instead of us
        Return New Hashtable
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------DEFAULT PLUGIN ELEMENT OPTION WHEN THE USER ADDS IT FOR THE FIRST TIME
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function SetDefaultOptions(sensor_name As String, elementData As Hashtable) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.SetDefaultOptions
        'Set the default values you want to have on your sensor when its created, if the user doesnt change any option, he will have this settings

        objHost.DebugMessage("DemoPlugin - Added plugin element: " & sensor_name & " to the display screen")

        If sensor_name = pluginId & "temp" Then
            'For temp, lets modify the goverlay defaults
            elementData("width") = 100
            elementData("height") = 41
            elementData("maxnum") = 5
        End If

        Return elementData
    End Function

    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------CALLBACK FROM GOVERLAY TO YOUR PLUGIN FOR SOME EVENTS
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Function CallBack(method As String) As Hashtable Implements GOverlayPlugin.Interfaces.IPlugin.CallBacks
        Dim returnHT As Hashtable = New Hashtable

        Try

            Dim value As Integer = 0

            If method = "willrequestvalues" Then
                'Comes here once per run (only if sensors are used thru here)                
            Else
                value = InternalGatherSensorsValues(method)
            End If

            returnHT("value") = value

        Catch ex As Exception
            objHost.DebugMessage("Error grabbing action : " & method)
        End Try

        Return returnHT
    End Function


    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '-----------CUSTOM DRAW ON THE DISPLAY FOR EACH ELEMENT
    '------------------------------------------------------------------------------------------------------------------------------------------------------------
    '------------------------------------------------------------------------------------------------------------------------------------------------------------

    Public Function DisplayOnLCD(sensor_name As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.DisplayOnLCD
        Return New ArrayList()
    End Function

    Public Function LCDSys2_DisplayOnLCD(sensor_name As String, elementData As Hashtable, pluginOptions As Hashtable, cacheRuns As Integer) As ArrayList Implements GOverlayPlugin.Interfaces.IPlugin.LCDSys2_DisplayOnLCD
        Return New ArrayList()
    End Function


    Public Function InternalGatherSensorsValues(sensorName As String) As String
        Dim theUnit As String = objHost.AccessHost("plugin_options", pluginName, "unit", "")

        If sensorName = pluginId & "temp" Then
            If theUnit = "celsius" Then
                Return 50
            Else
                Return 102
            End If
        ElseIf sensorName = pluginId & "usage" Then
            Return 55
        End If

        Return 0
    End Function
End Class